/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.Obj_Container;
import Game_Engine.Engine.Objs.View;
import Game_Engine.GUI.Components.small.gui_display;
import Game_Engine.GUI.Components.small.gui_look_and_feel;
import Game_Engine.GUI.Components.small.gui_scrollbar;
import java.awt.Color;

public class gui_window
extends Obj_Container {
    protected gui_look_and_feel background;
    private static final int background_depth = 2;
    protected gui_display world;
    private static final int world_depth = 1;
    private gui_scrollbar scrollV;
    private static final int scrollV_depth = 0;
    protected gui_scrollbar scrollH;
    private static final int scrollH_depth = 0;
    private gui_look_and_feel borders;
    private static final int borders_depth = -1;
    public static final int SCROLLBARSIZE = 25;
    private boolean dynamic_vScroll = true;
    private boolean dynamic_hScroll = true;

    public gui_window(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    public gui_window(Rectangle screen) {
        super(screen);
    }

    public gui_window(Rectangle screen, Rectangle sub_world, int worldW, int worldH) {
        super(screen);
        ((View)this.views.getFirst()).setViewBounds(screen, sub_world);
        int size = 2;
        this.world.getView().setWorldDimensions(worldW - size * 2, worldH - size * 2);
    }

    @Override
    protected void iViews() {
        Rectangle view = new Rectangle(0, 0, this.getW(), this.getH());
        Rectangle screen = new Rectangle((int)this.getX(), (int)this.getY(), this.getW(), this.getH());
        this.views = new List();
        this.views.add(new View(screen, view, this.getW(), this.getH()));
    }

    @Override
    public void iObjs() {
        int room_w = this.getW();
        int room_h = this.getH();
        this.background = new gui_look_and_feel(0.0, 0.0, room_w, room_h);
        this.background.setDrawBorders(false);
        this.background.setDepth(2);
        this.background.setColor(Color.WHITE);
        this.obj_gui_create(this.background);
        int border_size = 2;
        Rectangle screen = new Rectangle(border_size, border_size, room_w - 2 * border_size, room_h - 2 * border_size);
        this.world = new gui_display(screen);
        this.world.setDepth(1);
        this.obj_gui_create(this.world);
        this.borders = new gui_look_and_feel(0.0, 0.0, room_w, room_h);
        this.obj_gui_create(this.borders);
        this.borders.setDepth(-1);
        this.borders.makeTransparent();
        this.borders.setCollidable(false);
        this.borders.setPadding(0);
    }

    public void scroll() {
        this.scrollH();
        this.scrollV();
    }

    public void scrollH() {
        if (this.scrollH != null) {
            this.scrollH.setFlag(true);
            this.scrollH.enable();
            return;
        }
        int size = 25;
        int room_w = this.getW();
        int room_h = this.getH();
        this.scrollH = new gui_scrollbar(0.0, room_h - size, room_w, size);
        this.scrollH.setDepth(0);
        this.obj_gui_create(this.scrollH);
    }

    public void scrollV() {
        if (this.scrollV != null) {
            this.scrollV.setFlag(true);
            this.scrollV.enable();
            return;
        }
        int size = 25;
        int room_w = this.getW();
        int room_h = this.getH();
        this.scrollV = new gui_scrollbar(room_w - size, 0.0, size, room_h);
        this.scrollV.setDepth(0);
        this.obj_gui_create(this.scrollV);
    }

    public void unscroll() {
        this.unscrollV();
        this.unscrollH();
    }

    public void unscrollV() {
        if (this.scrollV == null) {
            return;
        }
        if (!this.dynamic_vScroll) {
            this.scrollV.disable();
            this.world.getView().setViewY(0);
            return;
        }
        this.scrollV.kill();
        this.scrollV = null;
        this.world.getView().setViewY(0);
    }

    public void unscrollH() {
        if (this.scrollH == null) {
            return;
        }
        if (!this.dynamic_hScroll) {
            this.scrollH.disable();
            this.world.getView().setViewX(0);
            return;
        }
        this.scrollH.kill();
        this.scrollH = null;
        this.world.getView().setViewX(0);
    }

    public Obj obj_gui_create(Obj o) {
        return super.obj_create(o);
    }

    @Override
    public Obj obj_create(Obj o) {
        return this.world.obj_create(o);
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        super.update();
        this.getView().setScreenX((int)this.getX());
        this.getView().setScreenY((int)this.getY());
        this.handleScrollbars();
    }

    public void handleScrollbars() {
        int border_size;
        View view;
        if (this.scrollH != null && this.scrollH.flag()) {
            view = this.world.getView();
            border_size = 2;
            int world_width = view.getWorldW();
            int window_w = view.getScreenW();
            int max_x = world_width - window_w + border_size * 2;
            if (this.scrollV != null) {
                max_x += this.scrollV.getW() - border_size;
            }
            int x_new = (int)((double)max_x * this.scrollH.getXValue());
            view.setViewX(x_new);
            if (view.flag()) {
                this.redraw();
            }
        }
        if (this.scrollV != null && this.scrollV.flag()) {
            view = this.world.getView();
            border_size = 2;
            int world_height = view.getWorldH();
            int window_h = view.getScreenH();
            int max_y = world_height - window_h + border_size * 2;
            if (this.scrollH != null) {
                max_y += this.scrollH.getH() - border_size;
            }
            int y_new = (int)((double)max_y * this.scrollV.getYValue());
            view.setViewY(y_new);
            if (view.flag()) {
                this.redraw();
            }
        }
    }

    public void setColor(Color c) {
        this.background.setColor(c);
    }

    public void setRestingColor(Color c) {
        this.background.setRestingColor(c);
    }

    @Override
    public void disable() {
        super.disable();
        this.world.disable();
    }

    @Override
    public void enable() {
        super.enable();
        this.world.enable();
    }

    public void setDrawBorders(boolean flag) {
        this.borders.setDrawBorders(flag);
    }

    @Override
    public void global_mouseScroll(int amount) {
        if (!this.mouseInRegion || this.scrollV == null) {
            return;
        }
        this.scrollV.scroll(amount);
        this.handleScrollbars();
    }

    @Override
    public void setH(int h) {
        boolean redraw;
        boolean bl = redraw = super.getH() != h;
        if (!redraw) {
            return;
        }
        this.redraw();
        super.setH(h);
        this.background.setH(h);
        this.borders.setH(h);
        View v = this.getView();
        v.setScreenH(h);
        v.setViewH(h);
        v.setWorldH(h);
        v = this.world.getView();
        v.setScreenH(h -= 4);
        v.setViewH(h);
        v.setWorldH(h);
        this.world.setH(h);
        if (this.scrollH != null) {
            this.scrollH.setY(this.getH() - this.scrollH.getH());
        }
        if (this.scrollV != null) {
            this.scrollV.setH(h + 4);
            double percentage = this.scrollV.getYValue();
            this.unscrollV();
            this.scrollV();
            this.scrollV.setYValue(percentage);
        }
        if (redraw) {
            this.redraw();
        }
    }

    @Override
    public void setW(int w) {
        boolean redraw;
        boolean bl = redraw = super.getW() != w;
        if (!redraw) {
            return;
        }
        this.redraw();
        super.setW(w);
        this.background.setW(w);
        this.borders.setW(w);
        View v = this.getView();
        v.setScreenW(w);
        v.setViewW(w);
        v.setWorldW(w);
        v = this.world.getView();
        v.setScreenW(w -= 2);
        v.setViewW(w);
        v.setWorldW(w);
        this.world.setW(w);
        if (this.scrollV != null) {
            this.scrollV.setX(this.getW() - this.scrollV.getW());
        }
        if (this.scrollH != null) {
            this.scrollH.setW(w + 4);
            double percentage = this.scrollH.getXValue();
            this.unscrollV();
            this.scrollV();
            this.scrollV.setXValue(percentage);
        }
        if (redraw) {
            this.redraw();
        }
    }

    public void scrollH(int worldW) {
        View v = this.world.getView();
        v.setWorldW(worldW);
        this.scrollH();
    }

    public void scrollV(int worldH) {
        View v = this.world.getView();
        v.setWorldH(worldH);
        this.scrollV();
    }

    public gui_display getWorld() {
        return this.world;
    }

    protected void ERROR(String s) {
        this.background.ERROR(s);
    }

    public void setDynamicVScroll(boolean b) {
        this.dynamic_vScroll = b;
        if (!b) {
            this.scrollV();
        }
    }

    public void setDynamicHScroll(boolean b) {
        this.dynamic_hScroll = b;
        if (!b) {
            this.scrollH();
        }
    }

    public void makeTransparent() {
        this.background.makeTransparent();
    }

    public void setScrollV(double percentage) {
        if (this.scrollV != null) {
            this.scrollV.setYValue(percentage);
        }
    }

    public void setScrollH(double percentage) {
        if (this.scrollH != null) {
            this.scrollH.setXValue(percentage);
        }
    }

    public boolean isScrollingH() {
        return this.scrollH != null;
    }

    public boolean isScrollingV() {
        return this.scrollV != null;
    }
}

